/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.common.util.CSVRecord;

public class PICageInfoDataBean
implements PIDataBeanInterface,
Comparable {
    public static final String CAGE_INT_NAME_KEY = "internal_name";
    public static final String CAGE_NUMBER_KEY = "cage_num";
    public static final String CAGE_TYPE_KEY = "contents";
    public static final String CAGE_STATUS_KEY = "status";
    public static final String CAGE_MTMS_KEY = "type_model_serial_num";
    public static final String LOCATION_CODE_KEY = "loc_code";
    public static final String FRAME_LOC_CODE_KEY = "frame_loc_code";
    public static final String OWNER_MTMS_KEY = "owner";
    public static final String OWNER_LOC_CODE_KEY = "owner_loc_code";
    public static final int CAGE_TYPE_MASK = 240;
    public static final int CAGE_TYPE_BPA = 0;
    public static final int CAGE_TYPE_CEC = 16;
    public static final int CAGE_TYPE_IO = 32;
    public static final int CAGE_TYPE_SWITCH = 48;
    public static final int CAGE_TYPE_EMPTY = 255;
    public static final String CAGE_TYPE_BPA_STRING = "bpa";
    public static final String CAGE_TYPE_CEC_STRING = "sys";
    public static final String CAGE_TYPE_IO_STRING = "io";
    public static final String CAGE_TYPE_EMPTY_STRING = "none";
    public static final String[] ALL_KEYS = new String[]{"internal_name", "contents", "status", "type_model_serial_num", "loc_code", "frame_loc_code", "owner", "owner_loc_code"};
    private String m_cageName = null;
    private int m_cageType = 0;
    private int m_cageStatus = 0;
    private String m_cageMtms = null;
    private String m_locCode = null;
    private String m_frameLocCode = null;
    private String m_ownerMtms = null;
    private String m_ownerLocCode = null;

    public String[] getAllKeys() {
        return ALL_KEYS;
    }

    public PICageInfoDataBean(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6) {
        this.m_cageName = string;
        this.m_cageType = n;
        this.m_cageStatus = n2;
        this.m_cageMtms = string2;
        this.m_locCode = string3;
        this.m_frameLocCode = string4;
        this.m_ownerMtms = string5;
        this.m_ownerLocCode = string6;
    }

    public String getCageName() {
        return this.m_cageName;
    }

    public int getCageType() {
        return this.m_cageType;
    }

    public int getCageStatus() {
        return this.m_cageStatus;
    }

    public String getCageMtms() {
        return this.m_cageMtms;
    }

    public String getLocCode() {
        return this.m_locCode;
    }

    public String getFrameLocCode() {
        return this.m_frameLocCode;
    }

    public String getOwnerMtms() {
        return this.m_ownerMtms;
    }

    public String getOwnerLocCode() {
        return this.m_ownerLocCode;
    }

    public void setCageName(String string) {
        this.m_cageName = string;
    }

    public void setCageType(int n) {
        this.m_cageType = n;
    }

    public void setCageStatus(int n) {
        this.m_cageStatus = n;
    }

    public void setCageMtms(String string) {
        this.m_cageMtms = string;
    }

    public void setLocCode(String string) {
        this.m_locCode = string;
    }

    public void setFrameLocCode(String string) {
        this.m_frameLocCode = string;
    }

    public void setOwnerMtms(String string) {
        this.m_ownerMtms = string;
    }

    public void setOwnerLocCode(String string) {
        this.m_ownerLocCode = string;
    }

    public String toString(String[] stringArray, boolean bl, String string) {
        CSVRecord cSVRecord = new CSVRecord(true, string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (CAGE_INT_NAME_KEY.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_cageName, bl);
                continue;
            }
            if (CAGE_NUMBER_KEY.equals(string2)) {
                int n;
                String string3 = null;
                if (this.m_cageName != null && (n = this.m_cageName.indexOf("*")) >= 0) {
                    string3 = this.m_cageName.substring(0, n);
                }
                CSVRecord.append(cSVRecord, string2, string3, bl);
                continue;
            }
            if (CAGE_TYPE_KEY.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getCageTypeString(), bl);
                continue;
            }
            if (CAGE_STATUS_KEY.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, Integer.toString(this.m_cageStatus), bl);
                continue;
            }
            if (CAGE_MTMS_KEY.equals(string2)) {
                if (bl && this.m_cageType == 255) continue;
                CSVRecord.append(cSVRecord, string2, this.m_cageMtms, bl);
                continue;
            }
            if (LOCATION_CODE_KEY.equals(string2)) {
                if (bl && this.m_cageType == 255) continue;
                CSVRecord.append(cSVRecord, string2, this.m_locCode, bl);
                continue;
            }
            if (FRAME_LOC_CODE_KEY.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_frameLocCode, bl);
                continue;
            }
            if (OWNER_MTMS_KEY.equals(string2)) {
                if (bl && (this.m_cageType & 0xF0) != 32) continue;
                if (this.m_ownerMtms != null) {
                    CSVRecord.append(cSVRecord, string2, this.m_ownerMtms, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, CAGE_TYPE_EMPTY_STRING, bl);
                continue;
            }
            if (!OWNER_LOC_CODE_KEY.equals(string2)) continue;
            CSVRecord.append(cSVRecord, string2, this.m_ownerLocCode, bl);
        }
        return cSVRecord.toString();
    }

    public String toString() {
        return "[" + this.toString(ALL_KEYS, true, ",") + "]";
    }

    public String getCageTypeString() {
        String string = null;
        if (this.m_cageType == 255) {
            string = CAGE_TYPE_EMPTY_STRING;
        } else {
            int n = this.m_cageType & 0xF0;
            switch (n) {
                case 0: {
                    string = CAGE_TYPE_BPA_STRING;
                    break;
                }
                case 16: {
                    string = CAGE_TYPE_CEC_STRING;
                    break;
                }
                case 32: {
                    string = CAGE_TYPE_IO_STRING;
                    break;
                }
                default: {
                    string = String.valueOf(this.m_cageType);
                }
            }
        }
        return string;
    }

    public int compareTo(Object object) {
        try {
            if (this.equals(object)) {
                return 0;
            }
            String string = ((PICageInfoDataBean)object).m_cageName;
            if (string != null) {
                Integer n = new Integer(string.substring(0, string.indexOf("*")));
                Integer n2 = new Integer(this.m_cageName.substring(0, this.m_cageName.indexOf("*")));
                return n2.compareTo(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return -1;
    }
}

